<?php

namespace App\Http\Controllers;

use App\Helpers\MetaHelper;
use App\Helpers\ProductsHelper;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Stringable;

class PaymentController extends Controller
{
    private $test_mode = true;

    public function payment($type)
    {
        $product = ProductsHelper::getProduct($type);

        $txn_id = MetaHelper::getCookie($type);
        // return $txn_id;
        $transactino_check = Transaction::where('client_txn_id', $txn_id)
            ->where('product_key', $type)
            ->first();
        if ($transactino_check !== NULL) {
            if ($transactino_check->status == 'success') {
                return view('payment-success', compact('txn_id', 'product', 'transactino_check'));
            }
        }
        return view('payment', compact('product'));
    }

    function generateRandomString($length = 10)
    {
        $characters = '0123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    public function testPaymentPage()
    {
        return view('test-payment-page');
    }

    public function test()
    {
        // return $this->phonePeInitiatePayment();
    }

    public function testPayment()
    {
        $customer_email = "itsmetheofficial@gmail.com";
        $customer_mobile = "8860554455";
        $customer_mobile = substr($customer_mobile, -10);

        $price = "10";
        $price = (int) $price . "00";

        $txnId = $this->generateRandomString(9);

        $url = 'https://api.phonepe.com/apis/pg/checkout/v2/pay';
        $payload = [
            'merchantOrderId' => $txnId,
            'amount'          => $price,
            'expireAfter'     => 1200, // Optional: default value is 1200 seconds if not provided.
            'paymentFlow'     => [
                'type'         => 'PG_CHECKOUT',
                'message'      => "Payment for Start Digital Website Product",
                'merchantUrls' => [
                    'redirectUrl' => url('/payment-success') . "/" . $txnId,
                ],
            ],
        ];

        // Optionally include metaInfo if provided
        $metaInfo = [
            'udf1'     => $txnId,
            'udf2' => $customer_email,
            'udf3' => $customer_mobile,
        ];

        $payload['metaInfo'] = $metaInfo;

        $accessToken = $this->phonePeAuthToken();
        $headers = [
            'Content-Type'  => 'application/json',
            'Authorization' => 'O-Bearer ' . $accessToken,
        ];


        $response = Http::withHeaders($headers)->post($url, $payload);
        if ($response->failed()) {
            // throw new \Exception("Error initiating payment: " . $response->body());
            return response()->failed("Error initiating payment: " . $response->body());
        }
        Log::info("Resepone: " . json_encode($response->json()));
        $redirectUrl = $response->json()['redirectUrl'];

        $payment_url = $redirectUrl;
        //redirect to payment url
        return redirect($payment_url);
    }

    public function markPaymentSuccess($txnId)
    {
        Log::info("Marking transaction as success: " . $txnId);
        $transaction = Transaction::where('id', $txnId)->first();
        if ($transaction) {
            Log::info("Transaction found: " . $transaction->client_txn_id);
            MetaHelper::markTransactionSuccess($transaction);
            return back()->with('success', 'Transaction marked as success!');
        }
        return back()->with('error', 'Transaction not found!');
    }

    public function phonePeInitiatePayment(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'product_key' => 'required|string',
            'platform' => 'in:meta,google,other'
        ]);

        $customer_name = $request->name;
        $product_key = $request->product_key;
        $customer_email = $request->email;
        $customer_mobile = preg_replace('/^\+?91|\D/', '', $request->phone);
        $customer_mobile = substr($customer_mobile, -10);
        $adClickId = $request->adClickId ?? NULL;
        $ip_address = $request->ip() ?? NULL;
        $user_agent = $request->header('User-Agent') ?? NULL;
        $platform = $request->platform;

        $product = ProductsHelper::getProduct($product_key);
        $price = $product['price'];
        if ($customer_mobile == '8860554455')
            $price = "10";
        $price = (int) $price . "00";

        $txnId = $this->generateRandomString(9);

        $url = 'https://api.phonepe.com/apis/pg/checkout/v2/pay';
        $payload = [
            'merchantOrderId' => $txnId,
            'amount'          => $price,
            'expireAfter'     => 1200, // Optional: default value is 1200 seconds if not provided.
            'paymentFlow'     => [
                'type'         => 'PG_CHECKOUT',
                'message'      => "Payment for Start Digital Website Product",
                'merchantUrls' => [
                    'redirectUrl' => url('/payment-success') . "/" . $txnId,
                ],
            ],
        ];

        // Optionally include metaInfo if provided
        $metaInfo = [
            'udf1'     => $txnId,
            'udf2' => $customer_email,
            'udf3' => $customer_mobile,
        ];

        $payload['metaInfo'] = $metaInfo;

        $accessToken = $this->phonePeAuthToken();
        $headers = [
            'Content-Type'  => 'application/json',
            'Authorization' => 'O-Bearer ' . $accessToken,
        ];


        $response = Http::withHeaders($headers)->post($url, $payload);
        if ($response->failed()) {
            // throw new \Exception("Error initiating payment: " . $response->body());
            return response()->failed("Error initiating payment: " . $response->body());
        }
        Log::info("Resepone: " . json_encode($response->json()));
        $redirectUrl = $response->json()['redirectUrl'];
        $orderId = $response->json()['orderId'];
        // $txnId = $orderId;

        // ✅ Use common function to create transaction
        $txnCreated = Transaction::createTransaction($product_key, $txnId, $customer_name, $customer_mobile, $customer_email, $adClickId, $ip_address, $user_agent, $platform);
        MetaHelper::setCookie($txnId, $product_key);

        //update server_txn_id =orderId
        $txnCreated->server_txn_id = $orderId;
        $txnCreated->save();

        $payment_url = $redirectUrl;
        return response()->success("Data Sent!", compact('payment_url', 'txnId'));
    }

    public function phonePeAuthToken()
    {
        $url = 'https://api.phonepe.com/apis/identity-manager/v1/oauth/token';
        $clientId      = env('PHONE_PE_CLIENT_ID');
        $clientSecret  = env('PHONE_PE_API_KEY');
        // For PROD, use the client_version as provided in your credentials email.
        $clientVersion = 0;
        $payload = [
            'client_id'      => $clientId,
            'client_version' => $clientVersion,
            'client_secret'  => $clientSecret,
            'grant_type'     => 'client_credentials',
        ];

        // Make the POST request with form data (Content-Type: application/x-www-form-urlencoded)
        $response = Http::asForm()->post($url, $payload);
        if ($response->failed()) {
            throw new \Exception("Error fetching auth token: " . $response->body());
        }
        // return $response->json();
        return $response->json()['access_token'];
    }

    public function SubmitPhonePePayment(Request $request)
    {
        Log::error("SubmitPhonePePayment webhook callback received");
        Log::error($request->all());

        $payload = $request->input('payload');
        if (!$payload) {
            Log::error("Payload not found in PhonePe callback");
            return response()->json(['error' => 'Payload is required'], 400);
        }

        $orderId = $payload['orderId'] ?? null;
        if (!$orderId) {
            Log::error("orderId missing in payload");
            return response()->json(['error' => 'orderId is required in payload'], 400);
        }

        $transaction = Transaction::where('client_txn_id', $orderId)
            ->orWhere('server_txn_id', $orderId)
            ->first();
        if (!$transaction) {
            Log::error("SubmitPhonePePayment: Transaction not found with orderId: " . $orderId);
            return response()->json(['error' => 'Transaction Not Found'], 404);
        }

        $state = $payload['state'] ?? null;
        if ($state == 'COMPLETED') {
            // Mark the transaction as successful
            MetaHelper::markTransactionSuccess($transaction);
            return response()->json(['message' => 'Transaction Done'], 200);
        }
    }


    public function createOrderCashFree(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'product_key' => 'required|string',
            'platform' => 'in:meta,google,other'
        ]);

        $customer_name = $request->name;
        $product_key = $request->product_key;
        $customer_email = $request->email;
        $customer_mobile = preg_replace('/^\+?91|\D/', '', $request->phone);
        $customer_mobile = substr($customer_mobile, -10);
        $adClickId = $request->adClickId ?? NULL;
        $ip_address = $request->ip() ?? NULL;
        $user_agent = $request->header('User-Agent') ?? NULL;
        $platform = $request->platform;
        $txnId = $this->generateRandomString(9);

        if (!env("CASHFREE_APP_ID") || !env("CASHFREE_SECRET_KEY")) {
            return response()->json(['error' => true, 'message' => 'Cashfree API credentials not found!'], 400);
        }

        // ✅ Use common function to create transaction
        Transaction::createTransaction($product_key, $txnId, $customer_name, $customer_mobile, $customer_email, $adClickId, $ip_address, $user_agent, $platform);
        MetaHelper::setCookie($txnId, $product_key);

        $product = ProductsHelper::getProduct($product_key);
        $price = $product['price'];
        if ($customer_mobile == '8860554455')
            $price = "10";


        $fields = [
            "order_id" => $txnId,
            "order_amount" => $price,
            // "order_amount" => 1,
            "order_currency" => "INR",
            "customer_details" => [
                "customer_id" => $txnId,
                "customer_name" => $customer_name,
                "customer_email" => $customer_email,
                "customer_phone" => $customer_mobile
            ],
            "order_note" => "Payment for Bundle Buy",
            "order_meta" => [
                "return_url" => "https://startdigital.site/payment-success" . "?order_id={order_id}"
            ]
        ];

        $cashfree_api_url = "https://api.cashfree.com/pg/orders";

        $response = Http::withHeaders([
            "accept" => "application/json",
            "x-client-id" => env("CASHFREE_APP_ID"),
            "x-client-secret" => env("CASHFREE_SECRET_KEY"),
            "x-api-version" => "2022-09-01",
            "content-type" => "application/json"
        ])->post($cashfree_api_url, $fields);

        $responseData = $response->json();
        Log::error("Cashfree API Response: " . json_encode($responseData));

        if (!$response->ok() || empty($responseData['payment_session_id'])) {
            Log::error("Cashfree Payment Error: " . json_encode($responseData));
            return response()->json(['error' => true, 'message' => 'Something went wrong!'], 500);
        }

        $payment_session_id = $responseData['payment_session_id'];
        $order_id = $txnId;

        // Store txnId in cookie for reference

        return response()->success("Data Sent!", compact('payment_session_id', 'order_id'));
    }

    public function RedirectUrlUpiGateway(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'product_key' => 'required|string',
            'platform' => 'in:meta,google,other'
        ]);

        $customer_name = $request->name;
        $product_key = $request->product_key;
        $customer_email = $request->email;
        $customer_mobile = preg_replace('/^\+?91|\D/', '', $request->phone);
        $customer_mobile = substr($customer_mobile, -10);
        $adClickId = $request->adClickId ?? NULL;
        $ip_address = $request->ip() ?? NULL;
        $user_agent = $request->header('User-Agent') ?? NULL;
        $platform = $request->platform;
        $txnId = $this->generateRandomString(9);

        if (!env("UPI_GATEWAY_API_KEY")) {
            return response()->failed('API Key Not Found!');
        }

        // ✅ Use common function to create transaction
        Transaction::createTransaction($product_key, $txnId, $customer_name, $customer_mobile, $customer_email, $adClickId, $ip_address, $user_agent, $platform);
        MetaHelper::setCookie($txnId, $product_key);

        $product = ProductsHelper::getProduct($product_key);
        $price = $product['price'];
        if ($customer_mobile == '8860554455')
            $price = "10";

        $fields = [
            "key" => env("UPI_GATEWAY_API_KEY"),
            "client_txn_id" => $txnId,
            "amount" => $price,
            "p_info" => "Bundle Buy Payment",
            "customer_name" => $customer_name,
            "customer_email" => $customer_email,
            "customer_mobile" => $customer_mobile,
            "redirect_url" => url('/payment-success') . "/" . $txnId,
            "udf1" => "user defined field 1",
            "udf2" => "user defined field 2",
            "udf3" => "user defined field 3",
        ];
        $http_request = Http::withHeaders([
            "Content-Type" => "application/json",
        ])->post("https://merchant.upigateway.com/api/create_order", $fields);
        $response = $http_request->json();

        Log::error($response);
        if (!$http_request->ok()) {
            $message = "Something went wrong!";
            return response()->failed($message);
        } else {

            if (!$response['status']) {
                $message = $response['msg'];
                return response()->failed($message);
            }

            $payment_url = $response["data"]["payment_url"];

            return response()->success("Data Sent!", compact('payment_url'));
        }
    }

    public function RedirectUrlPayFromUpi(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
            'product_key' => 'required|string',
            'platform' => 'in:meta,google,other'
        ]);

        $customer_name = $request->name;
        $product_key = $request->product_key;
        $customer_email = $request->email;
        $customer_mobile = preg_replace('/^\+?91|\D/', '', $request->phone);
        $customer_mobile = substr($customer_mobile, -10);
        $adClickId = $request->adClickId ?? NULL;
        $ip_address = $request->ip() ?? NULL;
        $user_agent = $request->header('User-Agent') ?? NULL;
        $platform = $request->platform;

        if (!env("PAYMENT_API_KEY")) {
            return response()->failed('API Key Not Found!');
        }

        $product = ProductsHelper::getProduct($product_key);
        $price = $product['price'];
        if ($customer_mobile == '8860554455')
            $price = "10";

        $txnId = $this->generateRandomString(9);

        // ✅ Use common function to create transaction
        Transaction::createTransaction($product_key, $txnId, $customer_name, $customer_mobile, $customer_email, $adClickId, $ip_address, $user_agent, $platform);
        MetaHelper::setCookie($txnId, $product_key);

        $fields = [
            'type' => 'any',
            'user_mobile' => $customer_mobile,
            'user_name' => $customer_name,
            'user_email' => $customer_email,
            'redirect_url' => url('/payment-success') . "/" . $txnId,
            'amount' => $price,
            'webhook_url_id' => env("WEBHOOK_URL_ID"),
            'txnId' => $txnId,
        ];


        $http_request = Http::withHeaders([
            "Content-Type" => "application/json",
        ])
            ->withToken(env("PAYMENT_API_KEY"))
            ->timeout(60)
            ->post("https://payfromupi.com/api/transactions/create", $fields);
        $response = $http_request->json();

        Log::error($response);

        if (!$http_request->ok()) {
            $message = "Something went wrong!";
            return response()->failed($message);
        } else {

            if (!$response['success']) {
                Log::error('error');
                $message = $response["message"];
                return response()->failed($message);
            }

            $payment_url = $response["data"]["paymentLink"];
            // $txnId = $response["data"]["txnId"];
            $qyeryUrl = $response["data"]["qyeryUrl"];



            return response()->success("Data Sent!", compact('payment_url', 'txnId', 'qyeryUrl'));
        }
    }

    public function paymentSuccess($txnId)
    {
        $transactino_check = Transaction::where('client_txn_id', $txnId)
            ->first();

        if ($transactino_check == NULL) {
            Log::error('Transaction not found with txn_id: ' . $txnId);
            abort(404, 'TXN Not Found');
        }

        if ($transactino_check->status != 'success') {
            //redirect to home page
            abort(404, 'TXN is not Success');
        }


        $txn_id = $txnId;
        $product = ProductsHelper::getProduct($transactino_check->product_key);
        Log::info('Payment Success page opened with txn_id: ' . $txn_id);
        return view('payment-success', compact('txn_id', 'transactino_check', 'product'));
    }


    public function SubmitPayFromUpiPayment(Request $request)
    {
        Log::error($request->all());
        if (!isset($request->txn_id)) {
            return response()->failed('Transaction ID is required');
        }

        $txn_id  = $request->txn_id;
        $transactino_check = Transaction::where('client_txn_id', $txn_id)
            ->first();

        if ($transactino_check === NULL) {
            Log::error('SubmitPayFromUpiPayment Transaction not found with txn_id: ' . $txn_id);
            return 'Transaction Not Found';
        }

        if ($request->status != 'completed') {
            return 'Transaction Failed';
        }

        $product = ProductsHelper::getProduct($transactino_check->product_key);
        $test_event_code = $product['backend_test_id_meta'];
        MetaHelper::markTransactionSuccess($transactino_check);
        // MetaHelper::markTransactionSuccess($transactino_check, $test_event_code);

        return 'Transaction Done';
    }
}
