<?php

namespace App\Http\Controllers\instaReels;

use App\Helpers\MetaHelper;
use App\Helpers\ProductsHelper;
use App\Http\Controllers\Controller;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Stringable;

class InstaReelsController extends Controller
{

    public function index(Request $request)
    {
        $product = ProductsHelper::getProduct('insta-reels');
        return view('insta-reels.home', compact('product'));
    }

    public function download($id)
    {
        $transaction = Transaction::where('client_txn_id', $id)
            ->first();
        if ($transaction === NULL) {
            $id = $_COOKIE['txnId'];
            $transaction = Transaction::where('client_txn_id', $id)
                ->first();
        }

        $product = ProductsHelper::getProduct($transaction->product_key);
        $filePath = public_path($product['download_file_link']);
        // return $filePath;

        if (!file_exists($filePath)) {
            abort(404, 'TXN Not Found');
        }

        return response()->download($filePath);
    }
}
