<?php

namespace App\Mail\instaReels;

use App\Helpers\ProductsHelper;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class OrderConfirmationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $transaction;
    private $product;

    public function __construct($transaction)
    {
        $this->transaction = $transaction;
        $this->product = ProductsHelper::getProduct($transaction->product_key);
    }

    public function build()
    {
        return $this->subject('✅ Your Purchase Was Successful!')
            ->view('insta-reels.paymentSuccessMail')
            ->with([
                'product_name' => $this->product['product_name'],
                'user_name' => $this->transaction->user_name,
                'txn_id' => $this->transaction->client_txn_id,
                'txn_date' => $this->transaction->created_at->format('M d, Y'),
                'user_mobile' => $this->transaction->user_mobile,
                'user_email' => $this->transaction->user_email,
                'price' => $this->product['price'],
                'download_bundle' => "https://drive.google.com/drive/folders/1BhSfthOy9i0K5z-BLDW53v1xAR_nnrKP",
                'free_bonus_1' => "https://drive.google.com/drive/folders/1kj3D8LqbD-hMOVOD8i0yroA6o3HTdtpp?usp=sharing",
                'free_bonus_2' => "https://drive.google.com/drive/folders/1q9rx8dKGhmYWBdVTbjDz7PuC3u6PXuEF?usp=drive_link",
                'free_bonus_3' => "https://drive.google.com/drive/folders/10YYPs43_ODxP9XCbywP-dVedyzA0Icn6?usp=drive_link",
                'all_links_pdf' => url('/download/' . $this->transaction->client_txn_id),
            ]);
    }
}
