<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Str;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = ['website', 'product_key', 'client_txn_id', 'user_name', 'user_mobile', 'user_email', 'status', 'adClickId', 'ip_address', 'user_agent', 'platform'];

    protected $casts = [
        'first_email_sent_at' => 'datetime',
        'second_email_sent_at' => 'datetime',
        'first_whatsapp_sent_at' => 'datetime',
        'second_whatsapp_sent_at' => 'datetime',
    ];

    /**
     * Create or update transaction record
     *
     * @param string $txnId
     * @param string $name
     * @param string $mobile
     * @param string $email
     * @return Transaction
     */

    public static function createTransaction($productKey, $txnId, $name, $mobile, $email, $customer_fbc, $ip_address, $user_agent, $platform)
    {

        return self::updateOrCreate(
            [
                'website' => env('WEBSITE'),
                'user_mobile' => $mobile,
                'product_key' => $productKey
            ], // Search criteria
            [
                'platform' => $platform,
                'user_email' => $email,
                'client_txn_id' => $txnId,
                'user_name' => $name,
                'status' => 'pending',
                'adClickId' => $customer_fbc,
                'ip_address' => $ip_address,
                'user_agent' => $user_agent,
                'platform' => $platform
            ]
        );
    }
}
