<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->enum('website', ['start_digital', 'kharid_india'])->default('insta-reels');
            $table->enum('product_key', ['insta-reels', 'buddha-bundle'])->default('insta-reels');
            $table->enum('platform', ['meta', 'google', 'other'])->default('other');
            $table->string('client_txn_id')->unique();
            $table->string('server_txn_id')->unique()->nullable()->default(NULL);
            $table->string('user_name');
            $table->string('user_mobile');
            $table->string('user_email');
            $table->string('status')->default('pending');
            $table->string('adClickId', 1000)->nullable()->default(NULL);
            $table->string('ip_address', 1000)->nullable()->default(NULL);
            $table->string('user_agent', 1000)->nullable()->default(NULL);
            //first_email_sent_at & second_email_sent_at
            $table->timestamp('first_email_sent_at')->nullable();
            $table->timestamp('second_email_sent_at')->nullable();
            //first_whatsapp_sent_at & second_whatsapp_sent_at
            $table->timestamp('first_whatsapp_sent_at')->nullable();
            $table->timestamp('second_whatsapp_sent_at')->nullable();
            $table->string('redirectUrl')->nullable()->default(NULL);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
