$(document).ready(function () {
  const second = 1000,
    minute = second * 60,
    hour = minute * 60;

  function setCookie(name, value, hours) {
    let expires = "";
    if (hours) {
      let date = new Date();
      date.setTime(date.getTime() + hours * 60 * 60 * 1000);
      expires = "; expires=" + date.toUTCString();
    }
    document.cookie = name + "=" + value + expires + "; path=/";
  }

  function getCookie(name) {
    let nameEQ = name + "=";
    let ca = document.cookie.split(";");
    for (let i = 0; i < ca.length; i++) {
      let c = ca[i].trim();
      if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
    }
    return null;
  }

  let endTime = getCookie("countdown_timer");
  if (!endTime) {
    endTime = new Date().getTime() + 5 * hour;
    setCookie("countdown_timer", endTime, 5);
  } else {
    endTime = parseInt(endTime, 10);
  }

  let x = setInterval(function () {
    const now = new Date().getTime(),
      distance = endTime - now;

    if (distance >= 0) {
      let hours = Math.floor(distance / hour);
      let minutes = Math.floor((distance % hour) / minute);
      let seconds = Math.floor((distance % minute) / second);

      $("#hours, #hours2, #hours3").text(hours.toString().padStart(2, "0"));
      $("#minutes, #minutes2, #minutes3").text(minutes.toString().padStart(2, "0"));
      $("#seconds, #seconds2, #seconds3").text(seconds.toString().padStart(2, "0"));
    } else {
      clearInterval(x);
      $("#hours, #hours2, #hours3, #minutes, #minutes2, #minutes3, #seconds, #seconds2, #seconds3").text("00");
    }
  }, 1000);

  $("#mobile_code").intlTelInput({
    initialCountry: "in",
    separateDialCode: true,
  });
});
