<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download Transactions</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 800px;
            margin: 20px auto;
            padding: 20px;
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }

        h2 {
            text-align: center;
            margin-bottom: 30px;
            color: #343a40;
            font-weight: bold;
        }

        .product-group {
            margin-bottom: 30px;
            padding: 20px;
            border: 1px solid #e9ecef;
            border-radius: 8px;
            background-color: #f8f9fa;
        }

        .product-group h3 {
            margin-bottom: 20px;
            color: #495057;
            font-weight: 600;
        }

        .data-section {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }

        .data-section h4 {
            margin-bottom: 10px;
            color: #6c757d;
            font-size: 18px;
            font-weight: 500;
        }

        .data-section p {
            margin: 5px 0;
            color: #495057;
            font-size: 16px;
        }

        .website-count {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }

        .website-count span {
            font-weight: 500;
        }

        button {
            display: block;
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border: none;
            background-color: #007bff;
            color: white;
            font-size: 16px;
            font-weight: 500;
            cursor: pointer;
            border-radius: 6px;
            transition: background-color 0.3s ease;
        }

        button:hover {
            background-color: #0056b3;
        }

        .count {
            margin-left: 5px;
            font-size: 14px;
            color: #fff;
            background-color: #6c757d;
            padding: 4px 8px;
            border-radius: 4px;
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .container {
                margin: 10px;
                padding: 15px;
            }

            .product-group {
                padding: 15px;
            }

            .data-section {
                padding: 10px;
            }

            h2 {
                font-size: 24px;
            }

            .product-group h3 {
                font-size: 20px;
            }

            .data-section h4 {
                font-size: 16px;
            }

            .data-section p {
                font-size: 14px;
            }

            button {
                font-size: 14px;
                padding: 10px;
            }
        }
    </style>
    <script>
        // Function to download CSV
        function downloadCSV(type, product) {
            window.location.href = `/download-transactions/${type}/${product}`;
        }

        // Function to view transaction list
        function viewList(product) {
            window.location.href = `/view-transactions/${product}`;
        }
    </script>
</head>

<body>
    <div class="container">
        <h2>Download Transactions</h2>

        @php

            $timePeriods = [
                'today' => "Today's Data",
                'yesterday' => "Yesterday's Data",
                'last_7_days' => 'Last 7 Days Data',
            ];

            $websiteNames = [
                'start_digital' => 'Start Digital',
                'kharid_india' => 'Kharid India',
            ];
        @endphp

        @foreach ($counts as $productKey => $productData)
            <div class="product-group">
                <h3>{{ $productTitles[$productKey] ?? ucfirst(str_replace('-', ' ', $productKey)) }}</h3>

                @foreach ($timePeriods as $periodKey => $periodLabel)
                    <div class="data-section">
                        <h4>{{ $periodLabel }}</h4>

                        <p>Success Payments:</p>
                        <div class="website-count">
                            @foreach ($websiteNames as $websiteKey => $websiteDisplay)
                                <span>{{ $websiteDisplay }}:
                                    {{ $productData['success'][$periodKey][$websiteKey] ?? 0 }}</span>
                            @endforeach
                        </div>

                        <p>Pending Payments:</p>
                        <div class="website-count">
                            @foreach ($websiteNames as $websiteKey => $websiteDisplay)
                                <span>{{ $websiteDisplay }}:
                                    {{ $productData['pending'][$periodKey][$websiteKey] ?? 0 }}</span>
                            @endforeach
                        </div>
                    </div>
                @endforeach

                <!-- Buttons -->
                <button onclick="downloadCSV('success','{{ $productKey }}')">
                    Download Purchases ({{ $productKey }}) <span
                        class="count">{{ $productData['success']['total'] ?? 0 }}</span>
                </button>
                <button onclick="downloadCSV('pending','{{ $productKey }}')">
                    Download ATC ({{ $productKey }}) <span
                        class="count">{{ $productData['pending']['total'] ?? 0 }}</span>
                </button>
                <button onclick="viewList('{{ $productKey }}')">
                    View Txns ({{ $productKey }}) <span
                        class="count">{{ ($productData['success']['total'] ?? 0) + ($productData['pending']['total'] ?? 0) }}</span>
                </button>
            </div>
        @endforeach
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
