@extends('insta-reels.master')

@section('meta_title', $product['meta_title'])
@section('meta_description', $product['meta_description'])

@section('content')
    <div class="main-wrpper">
        <!-- Header -->
        <header>
            <div class="container">
                <div class="header-top">
                    <p>Launch offer <span>Expiring in 5 hrs.</span> Get Instant Access Now, Hurry up!</p>
                </div>
            </div>
        </header>
        <!-- End Header -->
        <!-- Banner -->
        <section class="banner-wrp">
            <div class="container">
                <div class="banner-wrp-inner">
                    <h1>FIRST TIME ON INTERNET READY-MADE <span>MOTION GRAPHIC REELS BUNDLE</span></h1>
                    <p>100% Copyright & Watermark Free Just Upload & Start Earning!</p>
                </div>
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="banner-wrp-img">
                            <figure><img src="{{ asset('assets/insta-reels/images/banner-box.webp') }}" alt="box">
                            </figure>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="banner-wrp-data">
                            <ul class="banner-wrp-list">
                                <li>
                                    <figure><img src="{{ asset('assets/insta-reels/images/list-icon-1.svg') }}"
                                            alt="icon">
                                    </figure>
                                    (1080 Videos) Premium Quality
                                    <figure><img src="{{ asset('assets/insta-reels/images/list-icon-2.svg') }}"
                                            alt="icon">
                                    </figure>
                                </li>
                                <li>
                                    <figure><img src="{{ asset('assets/insta-reels/images/list-icon-1.svg') }}"
                                            alt="icon">
                                    </figure>
                                    One-Time Payment Lifetime Access
                                </li>
                                <li>
                                    <figure><img src="{{ asset('assets/insta-reels/images/list-icon-1.svg') }}"
                                            alt="icon">
                                    </figure>
                                    Free Lots of Bonuses
                                </li>
                                <li>
                                    <figure><img src="{{ asset('assets/insta-reels/images/list-icon-1.svg') }}"
                                            alt="icon">
                                    </figure>
                                    Perfect Size Format for Instagram.
                                </li>
                            </ul>
                            <h2>Time is Running out, BUY IT NOW!</h2>
                            <div id="countdown">
                                <ul>
                                    <li class="d-none"><span id="days"></span>days</li>
                                    <li><span id="hours"></span>Hours</li>
                                    <li><span id="minutes"></span>Minutes</li>
                                    <li><span id="seconds"></span>Seconds</li>
                                </ul>
                            </div>
                            <a href="/payment/insta-reels" id="buyNowButton" class="btn-main wow bounceIn">BUY NOW FOR
                                ₹{{ $product['price'] }}/-</a>

                            <p><span>₹{{ $product['main_price'] }}</span> “FOR FIRST 1000 PEOPLE ONLY”</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- End Banner -->

        <!-- Demo Videos -->
        <section class="videos-wrp">
            <div class="container">
                <div class="videos-wrp-inner">
                    <div class="comman-title">
                        <h2>Some Demo Videos... <figure><img src="{{ asset('assets/insta-reels/images/title-icon-1.svg') }}"
                                    alt="icon"></figure>
                        </h2>
                    </div>

                    <div class="videos-wrp-row">
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="videos-wrp-holder">
                                    <video controls poster="{{ asset('assets/insta-reels/images/poster1.webp') }}"
                                        preload="metadata">
                                        <source src="{{ asset('assets/insta-reels/images/video1.mp4') }}" type="video/mp4">
                                    </video>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="videos-wrp-holder">
                                    <video controls poster="{{ asset('assets/insta-reels/images/poster2.webp') }}"
                                        preload="metadata">
                                        <source src="{{ asset('assets/insta-reels/images/video2.mp4') }}" type="video/mp4">
                                    </video>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="videos-wrp-holder">
                                    <video controls poster="{{ asset('assets/insta-reels/images/poster3.webp') }}"
                                        preload="metadata">
                                        <source src="{{ asset('assets/insta-reels/images/video3.mp4') }}" type="video/mp4">
                                    </video>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h3>Time is Running out, BUY IT NOW!</h3>

                    <div id="countdown">
                        <ul>
                            <li class="d-none"><span id="days2"></span>days</li>
                            <li><span id="hours2"></span>Hours</li>
                            <li><span id="minutes2"></span>Minutes</li>
                            <li><span id="seconds2"></span>Seconds</li>
                        </ul>
                    </div>

                    <a href="/payment/insta-reels" id="buyNowButton" class="btn-primary wow bounceIn">BUY NOW FOR
                        ₹{{ $product['price'] }}/-</a>
                </div>
            </div>
        </section>
        <!-- End Demo Videos -->

        <!-- Cartoon Stories -->
        <section class="cartoon-wrp">
            <div class="container">
                <div class="comman-title-2">
                    <h2>CARTOON STORIES GROWTH <figure><img src="{{ asset('assets/insta-reels/images/title-icon-2.svg') }}"
                                alt="icon"></figure>
                    </h2>
                </div>

                <div class="cartoon-wrp-rw">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                            <div class="cartoon-wrp-holder">
                                <figure><img src="{{ asset('assets/insta-reels/images/cartoon-img-1.jpeg') }}"
                                        alt="Cartoon Stories">
                                </figure>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                            <div class="cartoon-wrp-holder">
                                <figure><img src="{{ asset('assets/insta-reels/images/cartoon-img-1.jpeg') }}"
                                        alt="Cartoon Stories">
                                </figure>
                            </div>
                        </div>
                        <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                            <div class="cartoon-wrp-holder">
                                <figure><img src="{{ asset('assets/insta-reels/images/cartoon-img-1.jpeg') }}"
                                        alt="Cartoon Stories">
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>

                <a href="/payment/insta-reels" id="buyNowButton" class="btn-primary wow bounceIn">BUY NOW FOR
                    ₹{{ $product['price'] }}/-</a>

                <p><span>₹{{ $product['main_price'] }}</span> “FOR FIRST 1000 PEOPLE ONLY”</p>
            </div>
        </section>
        <!-- End Cartoon Stories -->

        <!-- Customer Says -->
        <section class="videos-wrp customer-wrp">
            <div class="container">
                <div class="videos-wrp-inner">
                    <div class="comman-title">
                        <h2>What our Customer says about us... <figure><img
                                    src="{{ asset('assets/insta-reels/images/title-icon-1.svg') }}" alt="icon">
                            </figure>
                        </h2>
                    </div>

                    <div class="videos-wrp-row">
                        <div class="row">
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="customer-wrp-holder">
                                    <figure><img src="{{ asset('assets/insta-reels/images/customer-img-1.png') }}"
                                            alt="Customer">
                                    </figure>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="customer-wrp-holder">
                                    <figure><img src="{{ asset('assets/insta-reels/images/customer-img-2.png') }}"
                                            alt="Customer">
                                    </figure>
                                </div>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                                <div class="customer-wrp-holder">
                                    <figure><img src="{{ asset('assets/insta-reels/images/customer-img-3.png') }}"
                                            alt="Customer">
                                    </figure>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h3>Time is Running out, BUY IT NOW!</h3>

                    <div id="countdown">
                        <ul>
                            <li class="d-none"><span id="days3"></span>days</li>
                            <li><span id="hours3"></span>Hours</li>
                            <li><span id="minutes3"></span>Minutes</li>
                            <li><span id="seconds3"></span>Seconds</li>
                        </ul>
                    </div>

                    <a href="/payment/insta-reels" id="buyNowButton" class="btn-main wow bounceIn">BUY NOW FOR
                        ₹{{ $product['price'] }}/-</a>
                </div>
            </div>
        </section>
        <!-- End Customer Says -->


        <!-- Bonus -->
        {{-- <section class="bonus-wrp">
            <div class="container">
                <div class="comman-title">
                    <h2>Free Bonus</h2>
                </div>

                <div class="row">
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="bonus-wrp-img">
                            <figure><img src="{{ asset('assets/insta-reels/images/bonus-img-1.webp') }}" alt="bonus"></figure>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="bonus-wrp-img">
                            <figure><img src="{{ asset('assets/insta-reels/images/bonus-img-2.webp') }}" alt="bonus"></figure>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="bonus-wrp-img">
                            <figure><img src="{{ asset('assets/insta-reels/images/bonus-img-3.webp') }}" alt="bonus"></figure>
                        </div>
                    </div>
                </div>

                <a href="#" class="btn-secondary wow bounceIn">FREE ALL THESE BONUSES</a>

                <p>Don’t miss out on this incredible offer. Grab the Ready-Made Motion Graphic Reels Bundle
                    you need, plus <span>Bonuses</span> – all for just Rs. {{ $product['price'] }}!</p>
            </div>
        </section> --}}
        <!-- End Bonus -->

        <!-- Other Products -->
        <section class="other-products-wrp">
            <div class="container">
                <div class="comman-title text-center">
                    <h2>Other Products</h2>
                </div>

                <div class="row">
                    <!-- Product 1 -->
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="other-product-card">
                            <div class="product-image">
                                <figure>
                                    <img src="{{ asset('assets/insta-reels/images/bonus-img-1.webp') }}" alt="Product 1">
                                    <span class="discount-tag">20% OFF</span>
                                </figure>
                            </div>
                            <div class="product-info">
                                <h3>Instagram Money Mastery E-Books</h3>
                                <p class="price">
                                    <span class="discounted-price">₹199/-</span>
                                    <span class="original-price">₹249/-</span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- Product 2 -->
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="other-product-card">
                            <div class="product-image">
                                <figure>
                                    <img src="{{ asset('assets/insta-reels/images/bonus-img-2.webp') }}" alt="Product 2">
                                    <span class="discount-tag">15% OFF</span>
                                </figure>
                            </div>
                            <div class="product-info">
                                <h3>Viral AI Motivational Reels</h3>
                                <p class="price">
                                    <span class="discounted-price">₹299/-</span>
                                    <span class="original-price">₹349/-</span>
                                </p>
                            </div>
                        </div>
                    </div>
                    <!-- Product 3 -->
                    <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                        <div class="other-product-card">
                            <div class="product-image">
                                <figure>
                                    <img src="{{ asset('assets/insta-reels/images/bonus-img-3.webp') }}" alt="Product 3">
                                    <span class="discount-tag">25% OFF</span>
                                </figure>
                            </div>
                            <div class="product-info">
                                <h3>Viral ART & CRAFT Reels</h3>
                                <p class="price">
                                    <span class="discounted-price">₹149/-</span>
                                    <span class="original-price">₹199/-</span>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Center the button with "mx-auto" (Bootstrap) or custom CSS -->
                {{-- <div class="text-center mt-4">
                    <a href="/payment/insta-reels" id="buyNowButton" class="btn-secondary wow bounceIn">BUY OTHER PRODUCTS</a>
                </div> --}}

                <p class="text-center mt-3">
                    Don’t miss out on this incredible offer. Grab the Ready-Made Motion Graphic Reels Bundle plus
                    these additional products at an amazing price!
                </p>
            </div>
        </section>
        <!-- End Other Products -->




        <!-- Price -->
        <section class="price-wrp">
            <div class="container">
                <div class="price-wrp-inner">
                    <h3>Actual Price <span>₹{{ $product['main_price'] }}</span></h3>

                    <h2 class="wow swing">Today Price <span>₹{{ $product['price'] }}/-</span></h2>

                    <figure><img src="{{ asset('assets/insta-reels/images/payment.png') }}" alt="Payment"></figure>
                </div>
            </div>
        </section>
        <!-- End Price -->

        <!-- Whatsapp & Telegram -->
        @if (env('WHATSAPP_LINK') != null)
            <section class="whatsapp-wrp">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12">
                            <div class="whatsapp-wrp-icon">
                                <figure><img src="{{ asset('assets/insta-reels/images/whatsapp.png') }}" alt="whatsapp">
                                </figure>
                            </div>

                            <div class="whatsapp-wrp-data">
                                <h3>Limited Seats Available</h3>

                                <h2>Join the Best Free Bundle Whatsapp Community.</h2>

                                <p>In this Community, You will get Free Bonuses and Trending Bundle Notifications.</p>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12">
                            <div class="whatsapp-wrp-btn wow bounceIn">
                                <a href="{{ env('WHATSAPP_LINK') }}" target="blank">JOIN NOW</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        @endif
        @if (env('TELEGRAM_LINK') != null)
            <section class="whatsapp-wrp telegram-wrp">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12">
                            <div class="whatsapp-wrp-icon">
                                <figure><img src="{{ asset('assets/insta-reels/images/telegram.png') }}" alt="Telegram">
                                </figure>
                            </div>

                            <div class="whatsapp-wrp-data">
                                <h3>Talk with us on Telegram</h3>

                                <h2>Send “hi” to us</h2>

                                <p>We will reply to you, Shortly</p>
                            </div>
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12">
                            <div class="whatsapp-wrp-btn wow bounceIn">
                                <a href="{{ env('TELEGRAM_LINK') }}" target="blank">Send Message</a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- End Whatsapp & Telegram -->
        @endif
        <!-- FAQ -->
        <section class="faq-wrp">
            <div class="container">
                <div class="comman-title">
                    <h2>Frequently Asked Questions</h2>
                </div>

                <div class="accordion" id="accordionExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                What is included in the Bundle?
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>The bundle includes 1500+ Glowing Motion Graphic Reels that you can directly upload
                                    on Instagram</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                When will I receive my product?
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <ul>
                                    <li>1) Once your payment is complete, You will be redirected automatically to the
                                        download section of the page. Click the download button your will stated to
                                        download on your device.</li>
                                    <li>2) Apart from that you will also get the product download link in the email id
                                        provided during checkout. it might take 5 to 10 minutes to get that email.</li>
                                    <li>3) If you haven’t received the product through email we recommend you to check
                                        the spam folder or promotional tab email. all the files are uploaded in the
                                        drive. You can download it whenever you want it.</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                What if I lose my product?
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>I would advise you to download the product after making the purchase. If you
                                    encounter any issues after the purchase, please feel free to email me or DM me on
                                    Telegram. ({{ env('MAIL_FROM_ADDRESS') }})</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                Do I need any edits to upload?
                            </button>
                        </h2>
                        <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>No, you don’t need to edit anything, just Download & Upload.</p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                What are the Payment methods do you support?
                            </button>
                        </h2>
                        <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>We covered each and every payment method including wallets(Paytm, Phonepay, Gpay),
                                    Net Banking, Debit or Credit Cards, etc.</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="faq-wrp-bottom">
                    <h3>You still have more questions, please email us: {{ env('MAIL_FROM_ADDRESS') }}</h3>

                    <p>Don’t miss out on this incredible offer. Grab the Ready-Made Motion Graphic Reels<br>
                        you need, plus <span>Bonuses</span> - all for just Rs. {{ $product['price'] }}!</p>

                    <a href="/payment/insta-reels" id="buyNowButton" class="btn-main wow bounceIn">BUY NOW FOR
                        ₹{{ $product['price'] }}/-</a>

                    <figure><img src="{{ asset('assets/insta-reels/images/visa.jpg') }}" alt=""></figure>

                    <h4>
                        <figure><img src="{{ asset('assets/insta-reels/images/hand.svg') }}" alt="hand"></figure>
                        Take Action
                        Now, Don't Regret
                        Again. BUY
                        IT NOW!
                    </h4>
                </div>
            </div>
        </section>
        <!-- End FAQ -->

        <!-- Footer -->
        <footer>
            <div class="container">
                <div class="footer-inner">
                    <h2>DISCLAIMER</h2>

                    <p>This site is not a part of WhatsApp or Facebook. Mentioned names or logos are properties of their
                        respective companies. The information on this website is for educational purposes only, we
                        neither support nor be held responsible for any misuse of this info. We are not affiliated with
                        any brand or website. Buyer must use the files responsibly and adhere to the website terms or
                        usage policy (or whatever applicable).</p>

                    <ul class="footer-links">
                        <li><a href="https://startdigital.site/about-us">About Us</a></li>
                        <li><a href="https://startdigital.site/contact-us">Contact Us</a></li>
                        <li><a href="https://startdigital.site/privacy-policy">Privacy Policy</a></li>
                        <li><a href="https://startdigital.site/terms-and-conditions">Terms & Conditions</a></li>
                        <li><a href="https://startdigital.site/refund-and-cancellations">Refund & Cancellations</a></li>
                        {{-- <li><a href="https://startdigital.site/shipping-and-delivery">Shipping and Delivery</a></li> --}}
                    </ul>
                </div>
            </div>
        </footer>
        <!-- End Footer -->


    </div>
@endsection

@push('styles')
    <style>
        /* Existing footer styles */
        .footer-inner {
            text-align: center;
            padding: 20px 0;
            background-color: #222;
            color: white;
        }

        .footer-inner h2 {
            font-size: 24px;
            margin-bottom: 10px;
        }

        .footer-inner p {
            font-size: 14px;
            line-height: 1.6;
            margin-bottom: 20px;
        }

        .footer-links {
            display: flex;
            flex-wrap: wrap;
            justify-content: center;
            gap: 15px;
            list-style: none;
            padding: 0;
            margin-top: 15px;
        }

        .footer-links li {
            display: inline-block;
            text-align: center;
        }

        .footer-links a {
            font-size: 16px;
            color: #f8f9fa;
            text-decoration: none;
            font-weight: 500;
            padding: 10px 15px;
            border-radius: 5px;
            transition: 0.3s ease-in-out;
            display: inline-block;
        }

        .footer-links a:hover {
            background-color: #ff7b00;
            color: white;
        }

        @media (max-width: 600px) {
            .footer-links {
                flex-direction: column;
                text-align: center;
            }

            .footer-links li {
                width: 100%;
            }

            .footer-links a {
                display: block;
                padding: 10px;
            }
        }

        /* Other Products Section */
        .other-products-wrp {
            padding: 40px 0;
            background-color: #000;
            /* If you have a dark background */
        }

        /* Center the title text */
        .other-products-wrp .comman-title h2 {
            color: #fff;
            /* Make heading white for visibility on dark background */
            font-size: 28px;
            margin-bottom: 20px;
        }

        /* Product Card */
        .other-product-card {
            background: #222;
            /* Dark card background */
            color: #fff;
            border: 1px solid #333;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 20px;
            text-align: center;
        }

        .other-product-card .product-image {
            position: relative;
            display: inline-block;
            width: 100%;
            margin-bottom: 10px;
        }

        .other-product-card .product-image figure {
            margin: 0;
            position: relative;
        }

        .other-product-card .product-image img {
            width: 100%;
            height: auto;
            display: block;
            border-radius: 5px;
        }

        .other-product-card .discount-tag {
            position: absolute;
            top: 10px;
            right: 10px;
            background: #ff7b00;
            color: #fff;
            padding: 5px 10px;
            font-size: 12px;
            border-radius: 3px;
            font-weight: 600;
        }

        .other-product-card .product-info h3 {
            font-size: 16px;
            margin: 10px 0 5px;
            color: #fff;
        }

        .other-product-card .price {
            font-size: 15px;
            margin: 5px 0;
        }

        .discounted-price {
            color: #ff7b00;
            /* Highlight the discounted price */
            font-weight: bold;
            margin-right: 5px;
        }

        .original-price {
            text-decoration: line-through;
            color: #999;
            font-size: 14px;
        }

        /* Centering the button (if not using Bootstrap classes) */
        .other-products-wrp .btn-secondary {
            display: inline-block;
            margin: 0 auto;
            text-align: center;
        }
    </style>
@endpush


@push('scripts')
    <!-- script -->
    <script>
        document.getElementById('buyNowButton').addEventListener('click', function() {
            fbq('track', 'InitiateCheckout');
        });
    </script>
    <script src="{{ asset('assets/insta-reels/js/jquery.js') }}"></script>
    <script src="{{ asset('assets/insta-reels/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('assets/insta-reels/js/wow.min.js') }}"></script>
    <script src="{{ asset('assets/insta-reels/js/custom.js') }}"></script>
    <!-- End script -->
@endpush
