<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Privacy Policy</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }

        h2 {
            color: #555;
            margin-top: 30px;
            margin-bottom: 15px;
        }

        p {
            margin-bottom: 15px;
            text-align: justify;
        }

        ul {
            margin-bottom: 15px;
            padding-left: 20px;
        }

        ul li {
            margin-bottom: 10px;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 0.9em;
            color: #777;
        }

        .footer a {
            color: #007BFF;
            text-decoration: none;
        }

        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Privacy Policy</h1>
        <p><strong>Last updated on 20-02-2025</strong></p>
        <p>Welcome to <span class="highlight">StartDigital</span> (“we,” “our,” “us”). We are committed to protecting
            your privacy and ensuring that your personal information is handled in a safe and responsible manner. This
            Privacy Policy outlines how we collect, use, and protect your information when you visit our website <a
                href="https://startdigital.site">https://startdigital.site</a> and use our services.</p>

        <h2>1. Information We Collect</h2>
        <p>We may collect the following types of information:</p>
        <ul>
            <li><strong>Personal Information:</strong> Name, email address, phone number, and payment details when you
                register, make a purchase, or contact us.</li>
            <li><strong>Usage Data:</strong> Information about how you use our website, such as your IP address, browser
                type, pages visited, and time spent on the site.</li>
            <li><strong>Cookies:</strong> We use cookies to enhance your experience on our website. You can disable
                cookies in your browser settings, but this may affect your ability to use certain features of the site.
            </li>
        </ul>

        <h2>2. How We Use Your Information</h2>
        <p>We use your information for the following purposes:</p>
        <ul>
            <li>To process your orders and provide the products or services you request.</li>
            <li>To improve our website and services based on your feedback and usage patterns.</li>
            <li>To communicate with you about your account, orders, or inquiries.</li>
            <li>To send promotional emails or updates about our products and services (you can opt out at any time).
            </li>
        </ul>

        <h2>3. Sharing Your Information</h2>
        <p>We do not sell, trade, or rent your personal information to third parties. However, we may share your
            information with:</p>
        <ul>
            <li><strong>Service Providers:</strong> Third-party vendors who assist us in operating our website,
                processing payments, or delivering products.</li>
            <li><strong>Legal Requirements:</strong> If required by law or to protect our rights, property, or safety.
            </li>
        </ul>

        <h2>4. Data Security</h2>
        <p>We take reasonable measures to protect your personal information from unauthorized access, use, or
            disclosure. However, no internet transmission is completely secure, and we cannot guarantee absolute
            security.</p>

        <h2>5. Your Rights</h2>
        <p>You have the right to:</p>
        <ul>
            <li>Access, update, or delete your personal information.</li>
            <li>Opt out of receiving promotional emails.</li>
            <li>Request a copy of the data we hold about you.</li>
        </ul>
        <p>To exercise these rights, please contact us at <a
                href="mailto:{{ env('MAIL_FROM_ADDRESS') }}">{{ env('MAIL_FROM_ADDRESS') }}</a>.</p>

        <h2>6. Third-Party Links</h2>
        <p>Our website may contain links to third-party websites. We are not responsible for the privacy practices or
            content of these sites. Please review their privacy policies before providing any personal information.</p>

        <h2>7. Changes to This Privacy Policy</h2>
        <p>We may update this Privacy Policy from time to time. Any changes will be posted on this page with an updated
            revision date. We encourage you to review this policy periodically to stay informed.</p>

        <h2>8. Contact Us</h2>
        <p>If you have any questions or concerns about this Privacy Policy, please contact us at:</p>
        <ul>
            <li><strong>Email:</strong> <a
                    href="mailto:{{ env('MAIL_FROM_ADDRESS') }}">{{ env('MAIL_FROM_ADDRESS') }}</a>
            </li>
            <li><strong>Phone:</strong> <a href="tel:{{ env('SUPPORT_MOBILE') }}">{{ env('SUPPORT_MOBILE') }}</a></li>
        </ul>

        <div class="footer">
            <p>&copy; 2025 StartDigital. All rights reserved.</p>
            <p><a href="/terms-and-conditions">Terms & Conditions</a> | <a href="/contact-us">Contact Us</a></p>
        </div>
    </div>
</body>

</html>
