<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shipping & Delivery Policy</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            color: #333;
        }

        .container {
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        h1 {
            text-align: center;
            color: #333;
            margin-bottom: 20px;
        }

        h2 {
            color: #555;
            margin-top: 30px;
            margin-bottom: 15px;
        }

        p {
            margin-bottom: 15px;
            text-align: justify;
        }

        ul {
            margin-bottom: 15px;
            padding-left: 20px;
        }

        ul li {
            margin-bottom: 10px;
        }

        .highlight {
            color: #007BFF;
            font-weight: bold;
        }

        .footer {
            text-align: center;
            margin-top: 30px;
            font-size: 0.9em;
            color: #777;
        }

        .footer a {
            color: #007BFF;
            text-decoration: none;
        }

        .footer a:hover {
            text-decoration: underline;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>Shipping & Delivery Policy</h1>
        <p><strong>Last updated on 20-02-2025</strong></p>

        <h2>Digital Delivery Process</h2>
        <p>At <span class="highlight">StartDigital</span>, we specialize in instant digital delivery of our products.
            Since we offer <span class="highlight">Instagram Reels Bundles</span> (ready-to-upload video packages), there
            is <strong>no physical shipping</strong> involved. Your purchase will be delivered electronically via email
            immediately after successful payment.</p>

        <h2>How It Works</h2>
        <ul>
            <li><strong>Instant Access:</strong> After completing your purchase, you will receive a confirmation email
                containing a <strong>PDF file</strong> with download links to your Instagram Reels Bundle.</li>
            <li><strong>No Waiting Time:</strong> The digital product is available for download instantly – no shipping
                delays!</li>
            <li><strong>Easy to Use:</strong> The bundle includes pre-edited, high-quality videos that you can directly
                upload to your Instagram page to grow your audience.</li>
        </ul>

        <h2>What You’ll Receive</h2>
        <ul>
            <li>A PDF document with secure download links to your purchased video bundle.</li>
            <li>Clear instructions on how to access and use the videos.</li>
            <li>Lifetime access to the downloaded content (unless otherwise specified).</li>
        </ul>

        <h2>Shipping Policy (Physical Products)</h2>
        <p><span class="highlight">Not Applicable.</span> We do not sell or ship any physical products. All our products
            are digital and delivered electronically.</p>

        <h2>Need Help?</h2>
        <p>If you don’t receive your PDF/download links within 10 minutes of purchase:</p>
        <ol>
            <li>Check your <strong>Spam/Junk folder</strong>.</li>
            <li>Ensure you entered the correct email address during checkout.</li>
            <li>Contact us immediately at <a
                    href="mailto:{{ env('MAIL_FROM_ADDRESS') }}">{{ env('MAIL_FROM_ADDRESS') }}</a>
                or call <a href="tel:{{ env('SUPPORT_MOBILE') }}">{{ env('SUPPORT_MOBILE') }}</a> for support.</li>
        </ol>

        <h2>Refund & Delivery Issues</h2>
        <p>For refunds related to delivery failures or technical issues, please refer to our <a
                href="/refund-and-cancellations">Refund Policy</a> or <a href="/terms-and-conditions">Terms &
                Conditions</a>.</p>

        <div class="footer">
            <p>&copy; 2025 StartDigital. All rights reserved.</p>
            <p><a href="/terms-and-conditions">Terms & Conditions</a> | <a href="/contact-us">Contact Us</a></p>
        </div>
    </div>
</body>

</html>
