<?php

use App\Http\Controllers\buddhaBundle\BuddhaBundleController;
use App\Http\Controllers\ContentController;
use App\Http\Controllers\instaReels\InstaReelsController;
use App\Http\Controllers\MailController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PaymentControllerHelper;
use App\Http\Controllers\WhatsAppController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/test', [PaymentController::class, 'test']);
Route::get('/test-payment-page', [PaymentController::class, 'testPaymentPage']);
Route::get('/test-payment', [PaymentController::class, 'testPayment']);

//bundles
Route::get('/', [InstaReelsController::class, 'index'])->middleware('tracking');
Route::get('/insta-reels', [InstaReelsController::class, 'index'])->middleware('tracking');
Route::get('/buddha-bundle', [BuddhaBundleController::class, 'index'])->middleware('tracking');
Route::get('/buddha-bundle-bg', [BuddhaBundleController::class, 'indexBengali'])->middleware('tracking');

//mail routes
Route::get('/mail', [MailController::class, 'test']);
Route::get('order/{txnId}', [MailController::class, 'openOrder']);
Route::get('open-mail-free/{product}', [MailController::class, 'openMailFree']);
Route::get('/reorder/{txnId}', [MailController::class, 'reorder'])->name('reorder');
Route::get('/unsubscribe/{txnId}', [MailController::class, 'unsubscribe'])->name('reorder');

//whatsapp route
Route::get('/whatsapp', [WhatsAppController::class, 'test']);
Route::get('/image/order', [WhatsAppController::class, 'serveOrderImage']);
Route::get('/order-wp/{txnId}', [WhatsAppController::class, 'reorder'])->name('reorder');

//reorder route
Route::get('/view-transactions/{product_key}', [ContentController::class, 'viewTransactions']);
Route::get('/download', [ContentController::class, 'download']);
Route::get('/download-transactions/{type}/{product_key}', [ContentController::class, 'downloadCSV']);


Route::get('/about-us', [ContentController::class, 'about']);
Route::get('/contact-us', [ContentController::class, 'contact']);
Route::get('/privacy-policy', [ContentController::class, 'privacy']);
Route::get('/terms-and-conditions', [ContentController::class, 'terms']);
Route::get('/refund-and-cancellations', [ContentController::class, 'refund']);
Route::get('/shipping-and-delivery', [ContentController::class, 'shipping']);

//payments
Route::get('payment/{type}', [PaymentController::class, 'payment']);
Route::get('mark-success/{txnId}', [PaymentController::class, 'markPaymentSuccess']);

//createpayment routes
Route::post('phonepe-payment', [PaymentController::class, 'phonePeInitiatePayment']);
Route::post('cashfree-create-order', [PaymentController::class, 'createOrderCashFree']);
Route::post('upigateway', [PaymentController::class, 'RedirectUrlUpiGateway'])->name('payfromupi');
Route::post('payfromupix', [PaymentController::class, 'RedirectUrlPayFromUpi'])->name('payfromupi');
Route::get('payment-success/{txnId}', [PaymentController::class, 'paymentSuccess'])->name('payment-success');


Route::get('download/{id}', [InstaReelsController::class, 'download'])->name('download');
