

<?php $__env->startSection('meta_title', $product['meta_title']); ?>
<?php $__env->startSection('meta_description', $product['meta_description']); ?>

<?php $__env->startSection('content'); ?>
    <div class="payment-wrp">
        <div class="containerx" style="padding-left: unset; padding-right:unset; max-width:unset;">
            <div class="payment-form">
                <!-- Headline -->
                <h2 class="payment-headline">💡 Apke Payment Ke Baad Bundle Download Karne Ka Option Milega! 🔥</h2>

                <!-- Logo -->
                <div class="payment-logo">
                    <img src="<?php echo e(asset('circle_logo.png')); ?>" alt="Logo">
                </div>

                <h2>Please Enter Your Details</h2>

                <form id="payment-form">
                    <div class="form-group">
                        <input type="text" class="form-control" id="name" placeholder="Enter Name*" name="name"
                            autocomplete="name">
                    </div>

                    <div class="form-group">
                        <input type="email" class="form-control" id="email" placeholder="Enter Email*" name="email"
                            autocomplete="email">
                    </div>

                    <div class="form-group">
                        <div class="phone-wrapper">
                            <span>+91</span>
                            <input type="tel" class="phone-input" id="mobile_code" placeholder="Enter Phone*"
                                name="phone" autocomplete="tel">
                        </div>
                    </div>
                </form>

                <div class="amount-box">
                    <span>Amount:</span>
                    <span>₹<?php echo e($product['price']); ?></span>
                </div>

                <button class="payment-btn" id="payNow">
                    Make Payment <i class="fas fa-lock"></i>
                </button>

                <p class="secure-payment">🔒 Guaranteed safe & secure payment</p>

                <!-- Description Section -->
                <div class="payment-description">
                    <h3>Aapko Kya Milega?</h3>
                    <ul>
                        <li>✅ <b>No Copyright Issues:</b> Safe aur worry-free uploads ka suvidha.</li>
                        <li>✅ <b>4K HD Quality:</b> Aapke audience ko ek premium viewing experience milega.</li>
                        <li>✅ <b>No Logo Aur Watermarks:</b> Clean aur professional videos jo aapke brand ke liye perfect
                            hain.</li>
                        <li>✅ <b>Lifetime Access:</b> Ek baar ka payment, lifetime ka liye fayda.</li>
                        <li>✅ <b>Instant Downloads:</b> Abhi shuru karein bina kisi intezaar ke.</li>
                    </ul>
                    <p><b>Ye Bundle Aapke Liye Perfect Hai:</b> YouTube par Buddha stories upload karke apni earnings aur
                        influence badhayein.</p>
                    <p class="highlight">🔥 <b>Offer Limited Hai – Abhi Action Lejiye!</b></p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
    <link href="https://fonts.googleapis.com/css2?family=Hind+Madurai:wght@300;400;500;600;700&display=swap"
        rel="stylesheet">
    <style>
        .payment-headline {
            font-size: 18px;
            font-weight: bold;
            text-align: center;
            background: #ffe4b2;
            padding: 10px;
            border-radius: 8px;
            margin-bottom: 15px;
            color: #d35400;
        }

        .payment-description {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            text-align: left;
            margin-top: 20px;
        }

        .payment-description h3 {
            font-size: 18px;
            font-weight: bold;
            color: #333;
            margin-bottom: 10px;
        }

        .payment-description ul {
            list-style: none;
            padding: 0;
        }

        .payment-description ul li {
            font-size: 16px;
            margin-bottom: 8px;
            color: #555;
        }

        .highlight {
            color: red;
            font-weight: bold;
            text-align: center;
            margin-top: 10px;
        }
    </style>
    <style>
        /* Fixes white overflow issue on mobile */
        html,
        body {
            overflow-x: hidden;
            background: #f4f6f9;
            font-family: 'Inter', sans-serif;
        }

        .payment-wrp {
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 12px;
        }

        .payment-form {
            background: #fff;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
            text-align: center;
            max-width: 500px;
            /* Increased for better mobile fit */
            width: 100%;
            /* Adjusted for full mobile width */
        }

        .payment-logo img {
            display: block;
            margin: 0 auto 15px;
            max-width: 100px;
        }

        .payment-form h2 {
            font-size: 22px;
            font-weight: 700;
            color: #333;
            margin-bottom: 15px;
        }

        .form-group {
            margin-bottom: 15px;
            text-align: left;
        }

        .form-control {
            font-size: 16px;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 8px;
            width: 100%;
            transition: 0.3s;
        }

        .form-control:focus {
            border-color: #28a745;
            box-shadow: 0 0 8px rgba(40, 167, 69, 0.2);
        }

        .phone-wrapper {
            display: flex;
            align-items: center;
            background: #fff;
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 10px;
            width: 100%;
        }

        .phone-wrapper span {
            font-size: 16px;
            font-weight: bold;
            color: #333;
            padding-right: 8px;
            white-space: nowrap;
        }

        .phone-input {
            border: none;
            outline: none;
            font-size: 16px;
            flex: 1;
        }

        .amount-box {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 8px;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .payment-btn {
            display: inline-block;
            width: 100%;
            background: linear-gradient(135deg, #28a745, #218838);
            color: #fff;
            font-size: 18px;
            font-weight: bold;
            padding: 14px;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: 0.3s;
            box-shadow: 0 4px 10px rgba(40, 167, 69, 0.3);
        }

        .payment-btn:hover {
            background: linear-gradient(135deg, #218838, #1e7e34);
            transform: scale(1.05);
            box-shadow: 0 6px 15px rgba(40, 167, 69, 0.4);
        }

        .payment-btn i {
            margin-left: 8px;
        }

        .secure-payment {
            margin-top: 20px;
            font-size: 14px;
            color: #666;
        }

        /* Ensure no horizontal scrolling */
        @media (max-width: 768px) {
            body {
                overflow-x: hidden;
            }

            .payment-form {
                width: 100%;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
    <!-- script -->
    <script src="<?php echo e(asset('assets/insta-reels/js/jquery.js')); ?>"></script>
    <!-- End script -->

    <script src="https://sdk.cashfree.com/js/v3/cashfree.js"></script>
    <script>
        $(document).ready(function() {

            function getPlatform() {
                let platform = '';
                let fbCookieMatch = document.cookie.match(/_fbc=([^;]+)/);
                let fbClikIdCookieMatch = document.cookie.match(/fbclid=([^;]+)/);
                let gclidCookieMatch = document.cookie.match(/gclid=([^;]+)/);
                if (fbCookieMatch) {
                    platform = 'meta';
                } else if (fbClikIdCookieMatch) {
                    platform = 'meta';
                } else if (gclidCookieMatch) {
                    platform = 'google';
                } else {
                    const urlParams = new URLSearchParams(window.location.search);
                    if (urlParams.has('fbclid')) {
                        platform = 'meta';
                    } else if (urlParams.has('gclid')) {
                        platform = 'google';
                    } else {
                        platform = 'other';
                    }
                }
                return platform;
            }


            function getAdClickId() {
                let clickId = '';
                // Check for Facebook tracking from cookie
                let fbCookieMatch = document.cookie.match(/_fbc=([^;]+)/);
                let fbClikIdCookieMatch = document.cookie.match(/fbclid=([^;]+)/);
                let gclidCookieMatch = document.cookie.match(/gclid=([^;]+)/);
                if (fbCookieMatch) {
                    clickId = fbCookieMatch[1];
                } else if (fbClikIdCookieMatch) {
                    clickId = fbClikIdCookieMatch[1];
                } else if (gclidCookieMatch) {
                    clickId = gclidCookieMatch[1];
                } else {
                    const urlParams = new URLSearchParams(window.location.search);
                    if (urlParams.has('fbclid')) {
                        clickId = urlParams.get('fbclid');
                    } else if (urlParams.has('gclid')) {
                        clickId = urlParams.get('gclid');
                    }
                }
                return clickId;
            }


            $("#payNow").click(function(e) {
                e.preventDefault();

                let email = $("#email").val();
                let name = $("#name").val();
                let phone = $("#mobile_code").val();
                let adClickId = getAdClickId(); // Capture fbc
                let platform = getPlatform(); // Capture fbc
                let userAgent = navigator.userAgent;
                let productKey = "<?php echo e($product['key']); ?>";

                if (!email || !phone || !name) {
                    alert("Fill in your Name, Mobile and Email address.");
                    return;
                }

                if (!localStorage.getItem('AddPaymentInfo')) {
                    // Check the prefix and send the event to the specific platform only
                    if (platform == 'meta') {
                        console.log('Sending event to Facebook');
                        fbq('track', 'AddPaymentInfo', {
                            content_name: "Checkout Payment",
                            value: <?php echo e($product['price']); ?>,
                            currency: "INR"
                        });
                    } else if (platform == 'google') {
                        console.log('Sending event to Google');
                        var callback = function() {
                            if (typeof(url) != 'undefined') {
                                window.location = url;
                            }
                        };

                        gtag('event', 'conversion', {
                            'send_to': "<?php echo e($product['google_add_payment_info_event_id']); ?>",
                            'value': "<?php echo e($product['price']); ?>",
                            'currency': 'INR',
                            'event_callback': callback
                        });
                    }
                    localStorage.setItem('AddPaymentInfo', 'true');
                }

                // $backend_url = "/cashfree-create-order";
                // $backend_url = "/payfromupix";
                $backend_url = "/phonepe-payment";
                // $backend_url = "/upigateway";
                // $backend_url = "/cashfree-payment-url";

                $.ajax({
                    url: $backend_url,
                    type: "POST",
                    data: {
                        name: name,
                        email: email,
                        phone: phone,
                        adClickId: adClickId, // Pass Click ID
                        user_agent: userAgent, // Send User Agent
                        _token: "<?php echo e(csrf_token()); ?>",
                        product_key: productKey,
                        platform: platform
                    },
                    dataType: "json",
                    beforeSend: function() {
                        $("#payNow").prop("disabled", true).text("Processing...");
                    },
                    success: function(response) {
                        console.log(response);
                        if (response.error == false) {
                            if ($backend_url == "/cashfree-create-order") {
                                const cashfree = Cashfree({
                                    mode: "production" //sandbox or production
                                });
                                let checkoutOptions = {
                                    paymentSessionId: response.response.payment_session_id,
                                    redirectTarget: "_self",
                                };
                                cashfree.checkout(checkoutOptions);
                            } else {
                                let paymentUrl = response.response.payment_url;
                                let txnId = response.response.txnId;
                                localStorage.setItem("txnId", txnId);
                                window.location.href = paymentUrl;
                            }
                        } else {
                            alert(response.message || "Something went wrong.");
                        }
                    },
                    error: function(xhr) {
                        console.error(xhr.responseText);
                        alert("Payment failed! Please try again.");
                    },
                    complete: function() {
                        $("#payNow").prop("disabled", false).text("Pay Now");
                    }
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/shyambabamatka/public_html/startdigital.site/resources/views/payment.blade.php ENDPATH**/ ?>