<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v17/enums/asset_link_primary_status_reason.proto

namespace Google\Ads\GoogleAds\V17\Enums\AssetLinkPrimaryStatusReasonEnum;

use UnexpectedValueException;

/**
 * Enum Provides insight into why an asset is not serving or not serving
 * at full capacity for a particular link level. These reasons are
 * aggregated to determine a final PrimaryStatus.
 * For example, a sitelink might be paused by the user,
 * but also limited in serving due to violation of an alcohol policy. In
 * this case, the PrimaryStatus will be returned as PAUSED, since the asset's
 * effective status is determined by its paused state.
 *
 * Protobuf type <code>google.ads.googleads.v17.enums.AssetLinkPrimaryStatusReasonEnum.AssetLinkPrimaryStatusReason</code>
 */
class AssetLinkPrimaryStatusReason
{
    /**
     * Not specified.
     *
     * Generated from protobuf enum <code>UNSPECIFIED = 0;</code>
     */
    const UNSPECIFIED = 0;
    /**
     * Used for return value only. Represents value unknown in this version.
     *
     * Generated from protobuf enum <code>UNKNOWN = 1;</code>
     */
    const UNKNOWN = 1;
    /**
     * The asset is paused for its linked rollup level. Contributes to a
     * PrimaryStatus of PAUSED.
     *
     * Generated from protobuf enum <code>ASSET_LINK_PAUSED = 2;</code>
     */
    const ASSET_LINK_PAUSED = 2;
    /**
     * The asset is removed for its linked rollup level. Contributes to a
     * PrimaryStatus of REMOVED.
     *
     * Generated from protobuf enum <code>ASSET_LINK_REMOVED = 3;</code>
     */
    const ASSET_LINK_REMOVED = 3;
    /**
     * The asset has been marked as disapproved. Contributes to a PrimaryStatus
     * of NOT_ELIGIBLE
     *
     * Generated from protobuf enum <code>ASSET_DISAPPROVED = 4;</code>
     */
    const ASSET_DISAPPROVED = 4;
    /**
     * The asset has not completed policy review. Contributes to a PrimaryStatus
     * of PENDING.
     *
     * Generated from protobuf enum <code>ASSET_UNDER_REVIEW = 5;</code>
     */
    const ASSET_UNDER_REVIEW = 5;
    /**
     * The asset is approved with policies applied. Contributes to a
     * PrimaryStatus of LIMITED.
     *
     * Generated from protobuf enum <code>ASSET_APPROVED_LABELED = 6;</code>
     */
    const ASSET_APPROVED_LABELED = 6;

    private static $valueToName = [
        self::UNSPECIFIED => 'UNSPECIFIED',
        self::UNKNOWN => 'UNKNOWN',
        self::ASSET_LINK_PAUSED => 'ASSET_LINK_PAUSED',
        self::ASSET_LINK_REMOVED => 'ASSET_LINK_REMOVED',
        self::ASSET_DISAPPROVED => 'ASSET_DISAPPROVED',
        self::ASSET_UNDER_REVIEW => 'ASSET_UNDER_REVIEW',
        self::ASSET_APPROVED_LABELED => 'ASSET_APPROVED_LABELED',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AssetLinkPrimaryStatusReason::class, \Google\Ads\GoogleAds\V17\Enums\AssetLinkPrimaryStatusReasonEnum_AssetLinkPrimaryStatusReason::class);

