<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v17/services/recommendation_service.proto

namespace Google\Ads\GoogleAds\V17\Services;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request message for
 * [RecommendationService.GenerateRecommendations][google.ads.googleads.v17.services.RecommendationService.GenerateRecommendations].
 *
 * Generated from protobuf message <code>google.ads.googleads.v17.services.GenerateRecommendationsRequest</code>
 */
class GenerateRecommendationsRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The ID of the customer generating recommendations.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $customer_id = '';
    /**
     * Required. List of eligible recommendation_types to generate. If the
     * uploaded criteria isn't sufficient to make a recommendation, or the
     * campaign is already in the recommended state, no recommendation will be
     * returned for that type. Generally, a recommendation is returned if all
     * required fields for that recommendation_type are uploaded, but there are
     * cases where this is still not sufficient.
     * The following recommendation_types are supported for recommendation
     * generation:
     * KEYWORD, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * SITELINK_ASSET, TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.enums.RecommendationTypeEnum.RecommendationType recommendation_types = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $recommendation_types;
    /**
     * Required. Advertising channel type of the campaign.
     * The following advertising_channel_types are supported for recommendation
     * generation:
     * PERFORMANCE_MAX and SEARCH
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $advertising_channel_type = 0;
    /**
     * Optional. Number of sitelinks on the campaign.
     * This field is necessary for the following recommendation_types:
     * SITELINK_ASSET
     *
     * Generated from protobuf field <code>optional int32 campaign_sitelink_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $campaign_sitelink_count = null;
    /**
     * Optional. Current conversion tracking status.
     * This field is necessary for the following recommendation_types:
     * MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ConversionTrackingStatusEnum.ConversionTrackingStatus conversion_tracking_status = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $conversion_tracking_status = null;
    /**
     * Optional. Current bidding information of the campaign.
     * This field is necessary for the following recommendation_types:
     * MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.services.GenerateRecommendationsRequest.BiddingInfo bidding_info = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $bidding_info = null;
    /**
     * Optional. Current AdGroup Information.
     * Supports information from a single AdGroup.
     * This field is optional for the following recommendation_types:
     * KEYWORD
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.services.GenerateRecommendationsRequest.AdGroupInfo ad_group_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $ad_group_info;
    /**
     * Optional. Seed information for Keywords.
     * This field is necessary for the following recommendation_types:
     * KEYWORD
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.services.GenerateRecommendationsRequest.SeedInfo seed_info = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $seed_info = null;

    /**
     * @param string $customerId             Required. The ID of the customer generating recommendations.
     * @param int[]  $recommendationTypes    Required. List of eligible recommendation_types to generate. If the
     *                                       uploaded criteria isn't sufficient to make a recommendation, or the
     *                                       campaign is already in the recommended state, no recommendation will be
     *                                       returned for that type. Generally, a recommendation is returned if all
     *                                       required fields for that recommendation_type are uploaded, but there are
     *                                       cases where this is still not sufficient.
     *
     *                                       The following recommendation_types are supported for recommendation
     *                                       generation:
     *                                       KEYWORD, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     *                                       MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     *                                       SITELINK_ASSET, TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *                                       For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V17\Enums\RecommendationTypeEnum\RecommendationType}
     * @param int    $advertisingChannelType Required. Advertising channel type of the campaign.
     *                                       The following advertising_channel_types are supported for recommendation
     *                                       generation:
     *                                       PERFORMANCE_MAX and SEARCH
     *                                       For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V17\Enums\AdvertisingChannelTypeEnum\AdvertisingChannelType}
     *
     * @return \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest
     *
     * @experimental
     */
    public static function build(string $customerId, array $recommendationTypes, int $advertisingChannelType): self
    {
        return (new self())
            ->setCustomerId($customerId)
            ->setRecommendationTypes($recommendationTypes)
            ->setAdvertisingChannelType($advertisingChannelType);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $customer_id
     *           Required. The ID of the customer generating recommendations.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $recommendation_types
     *           Required. List of eligible recommendation_types to generate. If the
     *           uploaded criteria isn't sufficient to make a recommendation, or the
     *           campaign is already in the recommended state, no recommendation will be
     *           returned for that type. Generally, a recommendation is returned if all
     *           required fields for that recommendation_type are uploaded, but there are
     *           cases where this is still not sufficient.
     *           The following recommendation_types are supported for recommendation
     *           generation:
     *           KEYWORD, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     *           MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     *           SITELINK_ASSET, TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *     @type int $advertising_channel_type
     *           Required. Advertising channel type of the campaign.
     *           The following advertising_channel_types are supported for recommendation
     *           generation:
     *           PERFORMANCE_MAX and SEARCH
     *     @type int $campaign_sitelink_count
     *           Optional. Number of sitelinks on the campaign.
     *           This field is necessary for the following recommendation_types:
     *           SITELINK_ASSET
     *     @type int $conversion_tracking_status
     *           Optional. Current conversion tracking status.
     *           This field is necessary for the following recommendation_types:
     *           MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     *           MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     *           TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *     @type \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\BiddingInfo $bidding_info
     *           Optional. Current bidding information of the campaign.
     *           This field is necessary for the following recommendation_types:
     *           MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     *           MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     *           TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *     @type array<\Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\AdGroupInfo>|\Google\Protobuf\Internal\RepeatedField $ad_group_info
     *           Optional. Current AdGroup Information.
     *           Supports information from a single AdGroup.
     *           This field is optional for the following recommendation_types:
     *           KEYWORD
     *     @type \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\SeedInfo $seed_info
     *           Optional. Seed information for Keywords.
     *           This field is necessary for the following recommendation_types:
     *           KEYWORD
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V17\Services\RecommendationService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The ID of the customer generating recommendations.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getCustomerId()
    {
        return $this->customer_id;
    }

    /**
     * Required. The ID of the customer generating recommendations.
     *
     * Generated from protobuf field <code>string customer_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setCustomerId($var)
    {
        GPBUtil::checkString($var, True);
        $this->customer_id = $var;

        return $this;
    }

    /**
     * Required. List of eligible recommendation_types to generate. If the
     * uploaded criteria isn't sufficient to make a recommendation, or the
     * campaign is already in the recommended state, no recommendation will be
     * returned for that type. Generally, a recommendation is returned if all
     * required fields for that recommendation_type are uploaded, but there are
     * cases where this is still not sufficient.
     * The following recommendation_types are supported for recommendation
     * generation:
     * KEYWORD, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * SITELINK_ASSET, TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.enums.RecommendationTypeEnum.RecommendationType recommendation_types = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getRecommendationTypes()
    {
        return $this->recommendation_types;
    }

    /**
     * Required. List of eligible recommendation_types to generate. If the
     * uploaded criteria isn't sufficient to make a recommendation, or the
     * campaign is already in the recommended state, no recommendation will be
     * returned for that type. Generally, a recommendation is returned if all
     * required fields for that recommendation_type are uploaded, but there are
     * cases where this is still not sufficient.
     * The following recommendation_types are supported for recommendation
     * generation:
     * KEYWORD, MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * SITELINK_ASSET, TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.enums.RecommendationTypeEnum.RecommendationType recommendation_types = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setRecommendationTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::ENUM, \Google\Ads\GoogleAds\V17\Enums\RecommendationTypeEnum\RecommendationType::class);
        $this->recommendation_types = $arr;

        return $this;
    }

    /**
     * Required. Advertising channel type of the campaign.
     * The following advertising_channel_types are supported for recommendation
     * generation:
     * PERFORMANCE_MAX and SEARCH
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getAdvertisingChannelType()
    {
        return $this->advertising_channel_type;
    }

    /**
     * Required. Advertising channel type of the campaign.
     * The following advertising_channel_types are supported for recommendation
     * generation:
     * PERFORMANCE_MAX and SEARCH
     *
     * Generated from protobuf field <code>.google.ads.googleads.v17.enums.AdvertisingChannelTypeEnum.AdvertisingChannelType advertising_channel_type = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setAdvertisingChannelType($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\AdvertisingChannelTypeEnum\AdvertisingChannelType::class);
        $this->advertising_channel_type = $var;

        return $this;
    }

    /**
     * Optional. Number of sitelinks on the campaign.
     * This field is necessary for the following recommendation_types:
     * SITELINK_ASSET
     *
     * Generated from protobuf field <code>optional int32 campaign_sitelink_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getCampaignSitelinkCount()
    {
        return isset($this->campaign_sitelink_count) ? $this->campaign_sitelink_count : 0;
    }

    public function hasCampaignSitelinkCount()
    {
        return isset($this->campaign_sitelink_count);
    }

    public function clearCampaignSitelinkCount()
    {
        unset($this->campaign_sitelink_count);
    }

    /**
     * Optional. Number of sitelinks on the campaign.
     * This field is necessary for the following recommendation_types:
     * SITELINK_ASSET
     *
     * Generated from protobuf field <code>optional int32 campaign_sitelink_count = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setCampaignSitelinkCount($var)
    {
        GPBUtil::checkInt32($var);
        $this->campaign_sitelink_count = $var;

        return $this;
    }

    /**
     * Optional. Current conversion tracking status.
     * This field is necessary for the following recommendation_types:
     * MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ConversionTrackingStatusEnum.ConversionTrackingStatus conversion_tracking_status = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getConversionTrackingStatus()
    {
        return isset($this->conversion_tracking_status) ? $this->conversion_tracking_status : 0;
    }

    public function hasConversionTrackingStatus()
    {
        return isset($this->conversion_tracking_status);
    }

    public function clearConversionTrackingStatus()
    {
        unset($this->conversion_tracking_status);
    }

    /**
     * Optional. Current conversion tracking status.
     * This field is necessary for the following recommendation_types:
     * MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.enums.ConversionTrackingStatusEnum.ConversionTrackingStatus conversion_tracking_status = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setConversionTrackingStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V17\Enums\ConversionTrackingStatusEnum\ConversionTrackingStatus::class);
        $this->conversion_tracking_status = $var;

        return $this;
    }

    /**
     * Optional. Current bidding information of the campaign.
     * This field is necessary for the following recommendation_types:
     * MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.services.GenerateRecommendationsRequest.BiddingInfo bidding_info = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\BiddingInfo|null
     */
    public function getBiddingInfo()
    {
        return $this->bidding_info;
    }

    public function hasBiddingInfo()
    {
        return isset($this->bidding_info);
    }

    public function clearBiddingInfo()
    {
        unset($this->bidding_info);
    }

    /**
     * Optional. Current bidding information of the campaign.
     * This field is necessary for the following recommendation_types:
     * MAXIMIZE_CLICKS_OPT_IN, MAXIMIZE_CONVERSIONS_OPT_IN,
     * MAXIMIZE_CONVERSION_VALUE_OPT_IN, SET_TARGET_CPA, SET_TARGET_ROAS,
     * TARGET_CPA_OPT_IN, TARGET_ROAS_OPT_IN
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.services.GenerateRecommendationsRequest.BiddingInfo bidding_info = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\BiddingInfo $var
     * @return $this
     */
    public function setBiddingInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\BiddingInfo::class);
        $this->bidding_info = $var;

        return $this;
    }

    /**
     * Optional. Current AdGroup Information.
     * Supports information from a single AdGroup.
     * This field is optional for the following recommendation_types:
     * KEYWORD
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.services.GenerateRecommendationsRequest.AdGroupInfo ad_group_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdGroupInfo()
    {
        return $this->ad_group_info;
    }

    /**
     * Optional. Current AdGroup Information.
     * Supports information from a single AdGroup.
     * This field is optional for the following recommendation_types:
     * KEYWORD
     *
     * Generated from protobuf field <code>repeated .google.ads.googleads.v17.services.GenerateRecommendationsRequest.AdGroupInfo ad_group_info = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\AdGroupInfo>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdGroupInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\AdGroupInfo::class);
        $this->ad_group_info = $arr;

        return $this;
    }

    /**
     * Optional. Seed information for Keywords.
     * This field is necessary for the following recommendation_types:
     * KEYWORD
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.services.GenerateRecommendationsRequest.SeedInfo seed_info = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\SeedInfo|null
     */
    public function getSeedInfo()
    {
        return $this->seed_info;
    }

    public function hasSeedInfo()
    {
        return isset($this->seed_info);
    }

    public function clearSeedInfo()
    {
        unset($this->seed_info);
    }

    /**
     * Optional. Seed information for Keywords.
     * This field is necessary for the following recommendation_types:
     * KEYWORD
     *
     * Generated from protobuf field <code>optional .google.ads.googleads.v17.services.GenerateRecommendationsRequest.SeedInfo seed_info = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\SeedInfo $var
     * @return $this
     */
    public function setSeedInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V17\Services\GenerateRecommendationsRequest\SeedInfo::class);
        $this->seed_info = $var;

        return $this;
    }

}

